

#FACILITATIVE EFFECT####
#Merging tables to create graph of Grass greenness + dry weight + Grass height

fac_green <- Fac_eff_green %>% 
  dplyr::rename(Greenness = lsmean) %>% 
  dplyr::select(Canopy_0123, Greenness, Season_1234t, SE )

fac_GDW <- Fac_eff_GDW %>% 
  dplyr::rename(Dry_weight= lsmean) %>% 
  dplyr::select(Canopy_0123, Dry_weight, Season_1234t, SE)

fac_height <- Fac_eff_height %>% 
  dplyr::rename(Height = lsmean) %>% 
  dplyr::select(Canopy_0123, Height, Season_1234t, SE)


fac_GDW_green<- full_join (fac_GDW, fac_green, by= "Canopy_0123") %>% 
  filter_(~Season_1234t.x==Season_1234t.y)
  

fac_GDW_green_height<- full_join (fac_GDW_green, fac_height, by= "Canopy_0123") %>% 
  filter_(~Season_1234t.x==Season_1234t) %>% 
  pivot_longer(cols = (c("Dry_weight", "Greenness", "Height")),
               names_to = "Variables",
               values_to= "Effect",
               values_drop_na = TRUE) %>% 
  pivot_longer(cols = (c("SE.x", "SE.y", "SE")),
               names_to = "SE",
               values_to= "SE_values",
               values_drop_na = TRUE) %>% 
  filter(Variables == c("Dry_weight", "Greenness", "Height") & SE == c("SE.x", "SE.y", "SE"))



fac_GDW_green_height$Variables_ord <- factor(fac_GDW_green_height$Variables,          # Change ordering manually
                                         levels = c("Greenness", "Height", "Dry_weight"))

pd = position_dodge(0.2)
ggplot(fac_GDW_green_height, aes(x=Season_1234t, y=Effect, label=Variables, color = Variables) ) + 
  #geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Variables), size = 1, position = pd) +
  geom_errorbar(aes(ymin  =  Effect-SE_values, ymax  =  Effect+SE_values, color=Variables), width =  .1, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Facilitative effect", subtitle = "Palms, NF and NNF (Ind - LSMeans)") +
  labs( x = "Season", 
        y = "Community effect (%, cm and  g)", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("darkgreen", "dark magenta", "orange2"),
                     name = "Grass response",
                     labels=c( "Greenness", "Height", "Dry weight")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  #scale_x_continuous(expand = c(0,0), limits = c(0,600)) +
  facet_grid(cols = vars(Canopy_0123), labeller = Canopy )

facet_wrap("Canopy_0123", ncol =5)


canopy_types <- list(
  '1'="Palms",
  '2'="NF",
  '3'="NNF")

Canopy<- function(variable,value){
  return(canopy_types[value])
}

pd = position_dodge(0.2)
ggplot(fac_GDW_green_height, aes(x=Season_1234t, y=Effect, label=Canopy_0123, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  geom_errorbar(aes(ymin  =  Effect-SE_values, ymax  =  Effect+SE_values, color=Canopy_0123), width =  .1, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Facilitative effect", subtitle = "Palms, NF and NNF (Ind - LSMeans)") +
  labs( x = "Season", 
        y = "Community effect (%, cm and  g)", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  #scale_x_continuous(expand = c(0,0), limits = c(0,600)) +
  #facet_grid(cols = vars(Canopy_0123), labeller = Canopy )
  facet_wrap("Variables_ord", ncol =3)


Variables_list <- list(
  '1'="Palms",
  '2'="NF",
  '3'="NNF")

Variables_types<- function(variable,value){
  return(Variables_list[value])
}





#COMMUNITY FACILITATIVE EFFECT####
#Merging tables to create graph of Grass greenness + dry weight + Grass height


GDW <- marginal_comm_eff_ind_GDW %>% 
  dplyr::rename(Dry_weight = lsmean) %>% 
  dplyr::select(Canopy_0123, Dry_weight, precip_mm, SE)

green <- marginal_comm_eff_ind_green %>% 
  dplyr::rename(Greenness = lsmean) %>% 
  dplyr::select(Canopy_0123, Greenness, precip_mm, Season_1234t, SE)

height <- marginal_comm_eff_ind_height %>% 
  dplyr::rename(Height = lsmean) %>% 
  dplyr::select(Canopy_0123, Height, precip_mm, Season_1234t, SE)

 ##To join green, height and GDW####
GDW_green<- full_join (GDW, green, by= "Canopy_0123") %>% 
  filter_(~precip_mm.x==precip_mm.y)

GDW_green_height<- full_join (GDW_green, height, by= "Canopy_0123") %>% 
  filter_(~precip_mm.x==precip_mm) %>% 
  pivot_longer(cols = (c("Dry_weight", "Greenness", "Height")),
             names_to = "Variables",
             values_to= "Effect",
             values_drop_na = TRUE)  

GDW_green_height$Variables_ord <- factor(GDW_green_height$Variables,          # Change ordering manually
                                              levels = c("Greenness", "Height", "Dry_weight"))

####################################
####Graph original for three variables: grass height, green, GDW ####
####################################
##########################################
pd = position_dodge(0)
ggplot(GDW_green_height, aes(x=precip_mm, y=Effect, label=Variables_ord, color = Variables_ord) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_errorbar(aes(ymin=Effect-SE, ymax=Effect+SE), width=25, position=pd)+
  geom_line(aes(group=Variables_ord), size = 0.5, linetype= "dotted", position = pd) +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Community facilitative effect", subtitle = "Palms, NF and NNF (Ind - LSMeans)") +
  labs( x = "Precipitation (mm)", 
        y = "Community Facilitative Effect (%, cm and  g)", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("darkgreen", "dark magenta", "orange2"),
                     name = "Grass response",
                     labels=c( "Greenness", "Height", "Dry weight")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.3) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600)) +
  facet_grid(cols = vars(Canopy_0123), labeller = Canopy )

facet_wrap("Canopy_0123", ncol =5)


canopy_types <- list(
  '1'="Palms",
  '2'="NF",
  '3'="NNF")

Canopy<- function(variable,value){
  return(canopy_types[value])
}



#### To join green, height and GDW####
height_green<- full_join (height, green, by= "Canopy_0123") %>% 
  filter_(~precip_mm.x==precip_mm.y)%>% 
  pivot_longer(cols = (c("Greenness", "Height")),
             names_to = "Variables",
             values_to= "Effect",
             values_drop_na = TRUE) %>% 
  tidyr::pivot_longer(cols = (c("SE.x", "SE.y")),
                      names_to = "SE_variables",
                      values_to= "SE",
                      values_drop_na = TRUE) %>% 
  dplyr::filter(Variables == c("Height", "Greenness") & SE_variables == c("SE.x", "SE.y"))



height_green $ Variables_ord <- factor(height_green$Variables,          # Change ordering manually
                                        levels = c("Greenness", "Height"))

pd = position_dodge(0)
ggplot(height_green, aes(x=precip_mm.x, y=Effect, label=Variables_ord, color = Variables_ord) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Variables_ord), size = 0.5, linetype= "dotted", position = pd) +
    geom_errorbar(aes(ymin=Effect-SE, ymax=Effect+SE), width=50, position=pd)+
theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Overstory Community Effect", subtitle = "Palms, NF and NNF (Ind - LSMeans)") +
  labs( x = "Precipitation (mm)", 
        y = "Overstory Community Effect", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("darkgreen", "dark magenta", "orange2"),
                     name = "Grass response",
                     labels=c( "Greenness", "Height", "Dry weight")) +
  #scale_x_discrete(labels = c('Dry 18','Wet 18','Dry 19', 'Wet 19'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.3) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600)) +
  #scale_y_continuous(expand = c(0,0), limits = c(-20,10))+
  facet_grid(cols = vars(Canopy_0123), labeller = Canopy )

  facet_wrap("Canopy_0123", ncol =5)

  
canopy_types <- list(
  '1'="Palms",
  '2'="NF",
  '3'="NNF")

Canopy<- function(variable,value){
  return(canopy_types[value])
}

pd = position_dodge(0.2)
ggplot(GDW_green_height,  aes(x=precip_mm, y=Effect, label=Canopy_0123, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  #geom_errorbar(aes(ymin  =  Effect-SE_values, ymax  =  Effect+SE_values, color=Variables_ord), width =  .1, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Community facilitative effect", subtitle = "Palms, NF and NNF (Ind - LSMeans)") +
  labs( x = "Precipitation (mm)", 
        y = "Community effect (%, cm and  g)", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
 #scale_x_continuous(expand = c(0,0), limits = c(0,600)) +
  #facet_grid(cols = vars(Canopy_0123), labeller = Canopy )
  facet_wrap("Variables_ord", ncol =3)


#################################################
#Combined graphs height and greenness OE indiv####

#################################################

marginal_ind_eff_height <- marginal_ind_eff_height %>% 
  dplyr::rename(Height = lsmean)


marginal_ind_eff_green <- marginal_ind_eff_green %>% 
  dplyr::rename(Greenness = lsmean)


height_green_OE<- full_join (marginal_ind_eff_height, marginal_ind_eff_green, by= "Canopy_0123") %>% 
  dplyr::filter_(~precip_mm.x==precip_mm.y) %>% 
  tidyr::pivot_longer(cols = (c("Height", "Greenness")),
               names_to = "Variables",
               values_to= "Effect",
               values_drop_na = TRUE) %>% 
  tidyr::pivot_longer(cols = (c("SE.x", "SE.y")),
               names_to = "SE_variables",
               values_to= "SE",
               values_drop_na = TRUE) %>% 
  #filter_(~precip_mm.x==precip_mm.y)
dplyr::filter(Variables == c("Height", "Greenness") & SE_variables == c("SE.x", "SE.y"))

height_green_OE $ Variables_ord <- factor(height_green_OE$Variables,          # Change ordering manually
                                       levels = c("Greenness", "Height"))
#GRAPH PAPER INDIVIDUAL OCE
pd = position_dodge(0)
ggplot(height_green_OE, aes(x=Season_1234t.x, y=Effect, label=Variables_ord, color = Variables_ord) )+
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_errorbar(aes(ymin=Effect-SE, ymax=Effect+SE), width=.2, position=pd)+
  geom_line(aes(group=Variables_ord), size = 0.5, linetype= "dotted", position = pd) +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Overstory Effect", subtitle = "Palms, NF and NNF (Ind - LSMeans)") +
  labs( x = "Season", 
        y = "Overstory Canopy Effect", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("darkgreen", "dark magenta", "orange2"),
                     name = "Grass response",
                     labels=c( "Greenness", "Height", "Dry weight")) +
  scale_x_discrete(labels = c('Dry 18','Wet 18','Dry 19', 'Wet 19'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.3) +
  scale_y_continuous(expand = c(0,0), limits = c(-25,15)) +
  facet_grid(cols = vars(Canopy_0123), labeller = Canopy )
  #facet_wrap("Variables_ord", ncol =3)


labs( x = "Precipitation (mm)", 
      y = "Community effect (%, cm and  g)", 
      caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                        "Points indicate the LS mean. \n",
                        "Error bars indicate the Standard Error.\n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  #scale_x_continuous(expand = c(0,0), limits = c(0,600)) +
  #facet_grid(cols = vars(Canopy_0123), labeller = Canopy )
  facet_wrap("Variables_ord", ncol =3)






facet_wrap("Canopy_0123", ncol =5)


canopy_types <- list(
  '1'="Palms",
  '2'="NF",
  '3'="NNF")

Canopy<- function(variable,value){
  return(canopy_types[value])
}



